import { Component, OnInit, Input } from '@angular/core';
import { Response } from '@angular/http';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../store';

import { ConceptServices } from '../../../services/concept-services';
import { RoleServices } from '../../../services/role-services';
import { SystemServices } from '../../../services/system-services';

import {
  CONCEPT_CARD_POPULATING,
  UPDATE_CONCEPT_CARD_TAB_SELECTION,
  SET_CARD_DATA,
  SET_CURRENT_CONCEPT_SELECTED,
  NEW_CONCEPT_HISTORY,
  CONCEPT_CARD_POPULATED,
  ENABLE_CONCEPT_CARD_VIEW,
  CONCEPT_CARD_MVP_DELETED,
  CONCEPT_CARD_MVP_DELETING,
  UPDATE_BOOKMARKED_MAPPING,
  RESET_ADD_MVP_STATE,
  FOCUS_ON,
} from '../../../actions';

interface RemovableMvp {
  uri: string;
  value: string;
}

@Component({
  selector: 'app-mvp-remove',
  templateUrl: './mvp-remove.component.html',
  styleUrls: ['./mvp-remove.component.scss']
})
export class MvpRemoveComponent implements OnInit {
  @Input() tindex;
  @Input() isConceptLabel;
  @Input() tabType;
	@Input() removableMvp: RemovableMvp;
	@select(['conceptSearch', 'selectedConcept']) selectedConcept;
	@select(['conceptCard', 'conceptCardData']) conceptCardData;

  constructor(
  	private conceptServices: ConceptServices,
    private roleServices: RoleServices,
    private systemServices: SystemServices,
  	private ngRedux: NgRedux<IAppState>) { }

  ngOnInit() {
  }

  getState() {
  	return this.ngRedux.getState();
  }

  // If the uri of the concept card has prefix - then everything in that card can be removed.
  // ??? If a property of the response somewhere has a prefix - then that property can be removed


  isMvpRemovable(mvpObj) {
    // Check card's uri to see if it as a prefix -
    if (this.roleServices.isTerminologist()) {
      const conceptCardUri = this.getState().conceptCard.conceptCardData.uri;
      if (this.checkForMvpPrefix(conceptCardUri) || mvpObj.isMvp) {
        return true;
      } else {
        // Check that specific property passed into this method
        return this.checkForMvpPrefix(mvpObj.uri);
      }
    } else {
      return false;
    }
  }

  checkForMvpPrefix(string) {
    const allowlablePrefix = 'http://genisis.va.gov/mvp-schema#';
    if (string !== null && string.length > 0) {
      return string.indexOf(allowlablePrefix) > -1;  
    } else {
      return false;
    }
  }

  removeMvp(mvpObj) {
    this.ngRedux.dispatch({
      type: CONCEPT_CARD_MVP_DELETING
    });
    return this.conceptServices
      .removeMvpProperty(mvpObj)
      .subscribe((response: Response) => {
        if (response.status === 200) {
          if (this.isConceptLabel) {
            this.conceptServices.previousConcept();
          } else {
            const uri = this.getState().conceptCard.conceptCardData.uri;
            this.conceptServices
              .populateConceptCard(null, uri)
              .subscribe((response: Response) => {
                if (response.status === 200) {
                  const rdata = JSON.parse(response.text());
                  this.ngRedux.dispatch({
                    type: SET_CARD_DATA,
                    payload: rdata.response
                  });
                  this.ngRedux.dispatch({
                    type: SET_CURRENT_CONCEPT_SELECTED,
                    payload: rdata.response
                  });
                  this.ngRedux.dispatch({
                    type: RESET_ADD_MVP_STATE
                  });
                  this.ngRedux.dispatch({
                    type: CONCEPT_CARD_MVP_DELETED
                  });
                  this.ngRedux.dispatch({
                    type: FOCUS_ON,
                    payload: this.tabType
                  });
                  if (mvpObj.type == "DataElement") {
                    if (rdata.response.meta.dataElements == null || rdata.response.meta.dataElements.length < 1) {
                      this.ngRedux.dispatch({
                        type: UPDATE_BOOKMARKED_MAPPING,
                        payload: {
                          mappingFlag: false,
                          conceptUri: uri
                        }
                      });

                    }
                  }
                }
              });
          }
        }
      });
  }

}
